/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.client;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientOperator;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.util.SoundManager;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ClientCreativeOperator<T extends Operation>
extends ClientOperator<Operation> {
    public ClientCreativeOperator(AbstractContainerScreen<?> screen, ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper, Slot originSlot, T operation) {
        super(screen, screenHelper, originSlot, operation);
    }

    @Override
    protected void collect() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation COLLECT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation COLLECT", new Object[0]);
        }
        block0: for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            Slot srcSlot = this.originScopeSlots[i];
            ItemStack srcStack = this.originScopeStacks[i];
            if (srcStack.isEmpty() || srcStack.getCount() >= srcSlot.getMaxStackSize(srcStack)) continue;
            for (int j = 0; j < i; ++j) {
                Slot dstSlot = this.originScopeSlots[j];
                ItemStack dstStack = this.originScopeStacks[j];
                if (dstStack.isEmpty() || dstStack.getCount() >= dstSlot.getMaxStackSize(dstStack) || !ItemStack.isSameItemSameComponents((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                int delta = dstSlot.getMaxStackSize(dstStack) - dstStack.getCount();
                delta = Math.min(delta, srcStack.getCount());
                srcStack.shrink(delta);
                dstStack.grow(delta);
                int srcSlotId = ((ISlot)srcSlot).clientsort$getIdInContainer();
                int dstSlotId = ((ISlot)dstSlot).clientsort$getIdInContainer();
                InteractionManager.push(() -> {
                    Minecraft.getInstance().gameMode.handleCreativeModeItemAdd(srcStack.copy(), srcSlotId);
                    Minecraft.getInstance().gameMode.handleCreativeModeItemAdd(dstStack.copy(), dstSlotId);
                    return InteractionManager.TICK_WAITER;
                });
                if (srcStack.getCount() <= 0) continue block0;
            }
        }
        InteractionManager.push(() -> {
            Minecraft.getInstance().player.inventoryMenu.broadcastChanges();
            if (ClientSort.debug()) {
                ClientSort.LOG.info("Finished operation COLLECT", new Object[0]);
            }
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void sort(int[] key, boolean playSound) {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation SORT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation SORT", new Object[0]);
        }
        for (int i = 0; i < key.length; ++i) {
            ItemStack srcItem = this.originScopeStacks[key[i]];
            ItemStack dstItem = this.originScopeStacks[i];
            if (srcItem.isEmpty() && dstItem.isEmpty()) continue;
            int dstSlotId = ((ISlot)this.originScopeSlots[i]).clientsort$getIdInContainer();
            InteractionManager.push(() -> {
                Minecraft.getInstance().player.inventoryMenu.getSlot(dstSlotId).set(srcItem);
                Minecraft.getInstance().gameMode.handleCreativeModeItemAdd(srcItem, dstSlotId);
                if (playSound) {
                    SoundManager.play();
                }
                return InteractionManager.TICK_WAITER;
            });
        }
        InteractionManager.push(() -> {
            Minecraft.getInstance().player.inventoryMenu.broadcastChanges();
            if (ClientSort.debug()) {
                ClientSort.LOG.info("Finished operation SORT", new Object[0]);
            }
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void transfer() {
        if (ClientSort.debug()) {
            ClientSort.LOG.warn("Operation TRANSFER is not supported by {}", this.getClass().getSimpleName());
        }
    }

    @Override
    protected void fillStacks() {
        if (ClientSort.debug()) {
            ClientSort.LOG.warn("Operation STACK_FILL is not supported by {}", this.getClass().getSimpleName());
        }
    }
}

